Attribute VB_Name = "TrendTools"
Option Explicit
Option Compare Text

Dim HST As clsHST
Dim DataFile As clsDataFile

Dim Count As Long
'Dim Version As Integer
Dim strHeader As String

' 9/1/04 Modified to handle invalid nFiles
' 9/7/04 Added support for v6 trend files
Function GetTrendHeader(FileName As String, FileNo As Long) As String

    Dim Index As Long
    Dim nFiles As Long
    
    Set HST = New clsHST
    Set DataFile = New clsDataFile
    
    If GetExtension(FileName) = "hst" Then
        
        HST.Load FileNo
        
        strHeader = GetMasterHeader(HST.MasterHeader)
        
        If HST.MasterHeader.nFiles < 1 Then
            MsgBox "This header file is corrupt. ""# Files"" is < 1", vbOKOnly + vbCritical
            GetTrendHeader = strHeader
            Exit Function
        End If
        
        For Index = 0 To HST.HstHeaderCount - 1
            strHeader = strHeader & GetHstHdr(HST.HstHeader(Index), Index)
        Next Index
        
    Else 'data file

        DataFile.Load FileNo
        strHeader = GetDataHdr(DataFile.header)
        
    End If

    GetTrendHeader = strHeader

End Function

'1/4/04 Modified to add timestamp to each sample displayed.
'2/05   Corrected display of v6 data showing -1.#QNAN for good data
Function GetTrendData(Optional lstData, _
                      Optional StartSampleNo As Long = 1, _
                      Optional InputFileNo As Long, _
                      Optional OutputFileNo As Long, _
                      Optional NoFiles As Long, _
                      Optional CurrentFileCount As Long, _
                      Optional HideInvalid As Boolean = True) As Long
        
    Const BlockSize = 32768     'Max number of items in a listbox
    Const SampleValueOffset = 1
    Const SampleTimeOffset = 2
    Const SampleTimeMSOffset = 3
    
    Dim Samples As Variant
    Dim Count As Long
    Dim EventNo As Long
    Dim CancelMode As Long
    Dim SampleTimeDate As Currency
    Dim TimeOffset As Double
    Dim SamplePeriod As Long
    Dim StartTime As Currency
    Dim SampleText As String
    Dim LastSample As Long
    Dim EndSampleNo As Long
    Dim DataLength As Long
    Dim Cancel As Long
    Dim Percent As Single
    Dim ValidSamples As Long
    
    DataLength = (DataFile.header.FileSize - DataFile.header.HeaderSize) / DataFile.SampleSize
    
    If frmStatusBar.Visible = False Then frmStatusBar.Show
    
    If IsMissing(lstData) Then
        StartSampleNo = 1
        EndSampleNo = DataLength
        frmStatusBar.Text(0) = "Exporting data file " & CurrentFileCount & "/" & NoFiles
        Percent = ((CurrentFileCount - 1) / NoFiles) * 100
        frmStatusBar.Update Percent
        Samples = DataFile.GetSamples(InputFileNo, StartSampleNo, EndSampleNo)
    Else
        frmStatusBar.Text(0) = vbNullString
        frmStatusBar.Update Percent:=0
    
        If StartSampleNo = -1 Then
            EndSampleNo = DataLength
            StartSampleNo = DataLength - (DataLength Mod 32768) + 1
        Else
            EndSampleNo = IIf(StartSampleNo + BlockSize - 1 > DataLength, DataLength, StartSampleNo + BlockSize - 1)
        End If
        
        lstData.Visible = False     'AddItem is faster if it's invisible
        lstData.Clear
        Samples = DataFile.GetSamples(InputFileNo, StartSampleNo, EndSampleNo)
                        
    End If
    
    SamplePeriod = DataFile.header.SamplePeriod * 1000
    StartTime = DataFile.header.StartTime.Int64
    LastSample = DataFile.header.FilePointer
    
    frmStatusBar.Text(1) = "Formatting Samples"
    
    For Count = StartSampleNo To EndSampleNo

        If Count Mod 1000 = 0 Then
            Percent = (Count - StartSampleNo) / (EndSampleNo - StartSampleNo) * 100
            If NoFiles > 0 Then
                Percent = ((Percent / 100 / NoFiles) + ((CurrentFileCount - 1) / NoFiles)) * 100
            End If
            frmStatusBar.Update Percent, Cancel
            If Cancel = vbCancel Then
                frmStatusBar.Hide
                GetTrendData = vbCancel
                Exit Function
            End If
        End If
            
        TimeOffset = CDbl(Count - 1) * SamplePeriod
        SampleTimeDate = StartTime + TimeOffset
            
        With DataFile.header
            Select Case .HistoryType
            Case PeriodicTrend
                SampleText = FormatTime(SampleTimeDate) & vbTab
                SampleText = SampleText & FormatSample(Samples(Count), .Version, .EngZero, .EngFull, .sEngUnits, Count, LastSample)
            Case EventTrend
                Select Case .Version
                Case EightByteV531, EightByteV600
                    SampleText = DataFile.SampleTime(Count) & " [" & FormatTime(DataFile.SampleTime(Count)) & "]" & vbTab
                    SampleText = SampleText & FormatSample(DataFile.SampleValue(Count), .Version, .EngZero, .EngFull, .sEngUnits, Count, .EndEvNo - .StartEvNo)
                Case TwoByteOriginal, TwoBytePreV500, TwoByteV500, TwoByteV531, TwoByteV600
                    SampleText = DataFile.SampleTime(Count) & " [" & FormatTime(DataFile.SampleTime(Count)) & "]" & vbTab
                    SampleText = SampleText & FormatSample(DataFile.SampleValue(Count), .Version, .EngZero, .EngFull, .sEngUnits, Count, .EndEvNo - .StartEvNo)
                End Select
            Case Else
                MsgBox "Unknown history type:" & .HistoryType
                Exit Function
            End Select
        End With
        
        If IsValidSample(SampleText) Or (HideInvalid = False) Then
            If IsMissing(lstData) Then  'Export to file
                'Convert to CSV
                SampleText = Replace(SampleText, vbTab, ",")
                SampleText = Replace(SampleText, " [", ",")
                SampleText = Replace(SampleText, "]", "")
                SampleText = Replace(SampleText, "<", ",")
                SampleText = Replace(SampleText, ">", "")
                Print #OutputFileNo, SampleText
            Else                        'Populate listbox
                lstData.AddItem Count & ". " & SampleText
            End If
            ValidSamples = ValidSamples + 1
        End If
    Next Count
    
    If ValidSamples = 0 And Not IsMissing(lstData) Then
        lstData.AddItem "No valid samples to display"
    End If
    
    If Not IsMissing(lstData) Then lstData.Visible = True
    GetTrendData = DataLength

End Function
    

Function IsValidSample(Sample As String) As Boolean
    If InStr(Sample, "<Uninitialized data>") > 0 Then
        IsValidSample = False
    ElseIf InStr(Sample, "<NA>") > 0 Then
        IsValidSample = False
    ElseIf InStr(Sample, "<GATED>") > 0 Then
        IsValidSample = False
    Else
        IsValidSample = True
    End If
End Function

Sub ExportTrendFiles(SaveAs As String, ParentForm As Form)

    Dim OutputFileNo As Long
    Dim InputFileNo As Long
'    Dim SaveTo As String
    Dim NoFiles As Long
    Dim Index As Long
    Dim fileCounter As Long
    Dim FileName As String
    Dim InputText As String
    Dim Cancel As Long
    Dim FileDates() As Date
    Dim FileNumbers() As Long
    Dim BeginDate As Date
    Dim EndDate As Date
    
    Set HST = New clsHST
    
    InputFileNo = FreeFile
    Open ParentForm.txtfile.Text For Binary As InputFileNo
    HST.Load InputFileNo
    Close InputFileNo
        
    With HST.MasterHeader
        
        ReDim FileDates(0 To .nFiles - 1)
        ReDim FileNumbers(0 To .nFiles - 1)
           
        NoFiles = .nFiles
        For Index = 0 To NoFiles - 1
            FileDates(Index) = HST.HstHeader(Index).StartTime.VB
            FileNumbers(Index) = Index
        Next Index
        
        Index = UBound(FileDates)
        
    End With
    
    InsertionSort FileDates, FileNumbers
    
    OutputFileNo = FreeFile()

    ParentForm.MousePointer = vbHourglass

    Open SaveAs For Output As OutputFileNo

    Print #OutputFileNo, ParentForm.rtfDescription.Text
    
    Select Case HST.MasterHeader.Version
    Case EightByteV531, EightByteV600
        Print #OutputFileNo, "Time,Scaled Value,Description,State"    'Header for data export
    Case Else
        Print #OutputFileNo, "Time,Raw Value,Scaled Value,Description,State"    'Header for data export
    End Select
    
    For fileCounter = 0 To NoFiles - 1
        
        FileName = DropExtension(ParentForm.txtfile.Text) & "." & Format(fileCounter, "000")
        
        If FileExists(FileName) Then
        
            InputFileNo = FreeFile()
               
            Open FileName For Binary As InputFileNo
            
            GetTrendHeader FileName, InputFileNo
            Cancel = GetTrendData(InputFileNo:=InputFileNo, OutputFileNo:=OutputFileNo, CurrentFileCount:=fileCounter + 1, NoFiles:=NoFiles)
            Close InputFileNo
            If Cancel = vbCancel Then Exit For
        End If
    
    Next fileCounter
    
    frmStatusBar.Hide
    Close OutputFileNo
    
    If Cancel <> vbCancel Then MsgBox "Saved data to: " & SaveAs
        
    ParentForm.MousePointer = vbDefault

End Sub

Private Function GetMasterHeader(header As clsHSTMaster) As String
    Dim Text As String
    
    With header
        AddText Text, "Master Header"
        AddText Text, "Title", .Title
        AddText Text, "ID", .ID
        AddText Text, "File Type", .FileType, FormatFileType(.FileType)
        AddText Text, "Version", .Version, FormatVersion(.Version)
        AddText Text, "Mode", .Mode
        AddText Text, "Max Files", .History
        AddText Text, "# Files", .nFiles
        AddText Text, "Next", .NextFile
        AddText Text, "Add On", .AddOn
    End With
    
    GetMasterHeader = Text
End Function


Private Function GetHstHdr(HstHeader As clsHSTHeader, Index As Long) As String
        
    Dim Text As String
    
    With HstHeader
        AddText Text, "File Header " & Index
        AddText Text, "Name", .Name
        AddText Text, "ID", .ID
        AddText Text, "File Type", .FileType, FormatFileType(.FileType)
        AddText Text, "Version", .Version, FormatVersion(.Version)
        AddText Text, "Start Event #", .StartEvNo
        AddText Text, "Log Name", .LogName
        AddText Text, "Mode", .Mode
        AddText Text, "Area", .Area
        AddText Text, "Privilege", .Priv
        AddText Text, "History Type", .HistoryType, FormatHistoryType(.HistoryType)
        AddText Text, "Sample Period", .SamplePeriodRaw, .SamplePeriod & " sec"
        AddText Text, "Eng Units", .sEngUnits
        AddText Text, "Format", .Format, FormatCitectFormat(.Format)
        AddText Text, "Start Time", .StartTime.FormattedString, FormatTime(.StartTime.Raw)
        AddText Text, "End Time", .EndTime.FormattedString, FormatTime(.EndTime.Raw)
        AddText Text, "Data Length", .DataLength
        AddText Text, "File Pointer", .FilePointer
        AddText Text, "End Event #", .EndEvNo
    End With
    
    GetHstHdr = Text
End Function


Private Function GetDataHdr(header As clsDataHeader) As String
    Dim Text As String
    
    With header
        AddText Text, "Data File"
        AddText Text, "Title", .Title
        AddText Text, "Raw Zero", FormatScale(.RawZero)
        AddText Text, "Raw Full", FormatScale(.RawFull)
        AddText Text, "Eng Zero", FormatScale(.EngZero)
        AddText Text, "Eng Full", FormatScale(.EngFull)
        AddText Text, "ID", .ID
        AddText Text, "File Type", .FileType, FormatFileType(.FileType)
        AddText Text, "Version", .Version, FormatVersion(.Version)
        AddText Text, "Start Event #", .StartEvNo
        AddText Text, "Log Name", .LogName
        AddText Text, "Mode", .Mode
        AddText Text, "Area", .Area
        AddText Text, "Privilege", .Priv
        AddText Text, "History Type", .HistoryType, FormatHistoryType(.HistoryType)
        AddText Text, "Sample Period", .SamplePeriodRaw, .SamplePeriod & " sec"
        AddText Text, "Eng Units", .sEngUnits
        AddText Text, "Format", .Format, FormatCitectFormat(.Format)
        AddText Text, "Start Time", .StartTime.FormattedString, FormatTime(.StartTime.Raw)
        AddText Text, "End Time", .EndTime.FormattedString, FormatTime(.EndTime.Raw)
        AddText Text, "Data Length", .DataLength
        AddText Text, "File Pointer", .FilePointer
        AddText Text, "End Event #", .EndEvNo
    End With
    
    GetDataHdr = Text
End Function

Function FormatScale(Value As Single) As String
    FormatScale = Format(Value, "#########0.##########")
End Function


'Convert a Citect format integer into a Citect format string (e.g. ####.#)
Function FormatCitectFormat(ByVal binFormat As Long) As String
    
    Dim strFormat As String
    Dim Decimals As Long
    Dim NextChar As Long    'Next character position to use for format modifers
    
    Const WidthMask = 255
    Const DecimalsMask = 65280
    Const ZeroPaddingMask = 65536
    Const LeftJustifiedMask = 131072
    Const EuDisplayMask = 262144
    Const ExponentialMask = 1048576
    
    NextChar = 2
    
    Decimals = (binFormat And DecimalsMask) / 255
    
    strFormat = String((binFormat And WidthMask) - Decimals, "#")
    
    If Decimals > 0 Then
        strFormat = Left$(strFormat, Len(strFormat) - 1)
        strFormat = strFormat & "." & String(Decimals, "#")
    End If
    
    If (binFormat And ZeroPaddingMask) = ZeroPaddingMask Then
        Mid$(strFormat, NextChar, 1) = "0"
        NextChar = NextChar + 1
    End If
    
    If (binFormat And LeftJustifiedMask) = LeftJustifiedMask Then
        Mid$(strFormat, NextChar, 1) = "-"
        NextChar = NextChar + 1
    End If
    
    If (binFormat And ExponentialMask) = ExponentialMask Then
        Mid$(strFormat, NextChar, 1) = "s"
    End If

    If (binFormat And EuDisplayMask) = EuDisplayMask Then
        strFormat = strFormat & "EU"
    End If
    
    FormatCitectFormat = strFormat

End Function


'Convert a 2-byte or 8-byte sample value into either the value, <NA>, or <GATED>
'The raw value is followed by the engineering value for 2-byte trends (8-byte
'samples are already in eng units)
Function FormatSample(ByVal Sample As Variant, _
                      ByVal Version As TrendVersionEnum, _
                      Optional ByVal EngZero As Double, _
                      Optional ByVal EngFull As Double, _
                      Optional ByVal EngUnits As String, _
                      Optional ByVal SampleNo As Long, _
                      Optional ByVal NoSamples As Long) As String
                      
    Const InvalidData8 As Currency = -7505884848.2373@          'If 8-byte Trend sample is <NA>, it is recorded as this LONG value instead of a valid DOUBLE
    Const GatedData8 As Currency = -9382356060.2966@            'If 8-byte Trend sample is <GATED>, it is recorded as this LONG value instead of a valid DOUBLE

    Const InvalidData2 As Integer = -32001                      'Indicates invalid sample <NA> in 2-byte Trend data
    Const GatedData2 As Integer = -32002                        'Indicates gated data <GATED> in 2-byte Trend data
                      
    Dim EngVal As Double
    
    EngUnits = ToNull(EngUnits)
    
    If (Version = EightByteV531) Or (Version = EightByteV600) Then
        
        Select Case CastDoubleAsCurrency(Sample)
        Case InvalidData8
            FormatSample = "<NA>"
        Case GatedData8
            FormatSample = "<GATED>"
        Case Else
            FormatSample = Sample
        End Select
        
    Else    '2-byte
        Select Case Sample
        Case InvalidData2
            FormatSample = Sample & " [<NA>]"
        Case GatedData2
            FormatSample = Sample & " [<GATED>]"
        Case Else
            If (EngZero = 0) And (EngFull = 32000) Then
                FormatSample = Sample
            Else
                EngVal = ScaledVal(Sample, EngZero, EngFull)
                If EngUnits <> vbNullString Then EngUnits = " " & EngUnits
                FormatSample = Sample & " [" & EngVal & EngUnits & "]"
            End If
        End Select
        
    End If
    
    If SampleNo > NoSamples Then FormatSample = FormatSample & " <Uninitialized data>"
    
End Function


'Converts Citect 2-byte Trend raw value (generic scale: 0-32000) into engineering units in a Double
'suitable for Citect 8-byte trends
Function ScaledVal(ByVal RawVal As Double, ByVal EngZero As Double, ByVal EngFull As Double) As Double
    Const dbl2ByteRange As Double = 32000#
    
    Dim M As Double     'Slope (scale factor)
    
    M = (EngFull - EngZero) / dbl2ByteRange
    ScaledVal = M * RawVal + EngZero
    
End Function


Function FormatFileType(ByVal FileType As Integer) As String
    
    If FileType = 0 Then
        FormatFileType = "Trend file"
    Else
        FormatFileType = "Unknown"
    End If
    
End Function


Function FormatVersion(ByVal Version As TrendVersionEnum) As String
    
    Select Case Version
    Case TwoByteOriginal
        FormatVersion = "2-byte Pre v5.00"
    Case TwoBytePreV500
        FormatVersion = "2-byte Pre v5.00 scales"
    Case TwoByteV500
        FormatVersion = "2-byte v5.00-5.30"
    Case TwoByteV531
        FormatVersion = "2-byte v5.31-5.5x"
    Case EightByteV531
        FormatVersion = "8-byte v5.31-5.5x"
    Case TwoByteV600
        FormatVersion = "2-byte v6.00+"
    Case EightByteV600
        FormatVersion = "8-byte v6.00+"
    Case Else
        FormatVersion = "Unknown"
    End Select
    
End Function


Function FormatHistoryType(ByVal HistoryType As HistoryTypeEnum) As String
    
    Select Case HistoryType
    Case PeriodicTrend
        FormatHistoryType = "Periodic Trend"
    Case EventTrend
        FormatHistoryType = "Event Trend"
    Case Else
        FormatHistoryType = "Unknown"
    End Select
    
End Function

