Attribute VB_Name = "StringTools"
Option Explicit

Declare Sub MemCopy Lib "kernel32" Alias "RtlMoveMemory" (lpDest As Any, lpSource As Any, ByVal dwBytes As Long)
Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long

Const LB_SETTABSTOPS As Long = &H192


Function FormatCurrencyAsInt64(Value As Variant) As String
    FormatCurrencyAsInt64 = Replace(FormatNumber(Value, NumDigitsAfterDecimal:=4, groupdigits:=vbFalse), find:=".", Replace:="")
End Function


' Enable/Disable the WordWrap style of a RichTextBox control
'
' Example:
'    Private Sub Check1_Click()
'        SetRichTextBoxWordWrap RichTextBox1, (Check1.Value = vbChecked)
'    End Sub
Sub SetRichTextBoxWordWrap(ByVal ctlRichText As RichTextBox, Optional ByVal bState As Boolean = True)
    Const WM_USER As Long = &H400
    Const EM_SETTARGETDEVICE As Long = WM_USER + 72
    SendMessage ctlRichText.hwnd, EM_SETTARGETDEVICE, 0, CLng(IIf(bState, 0, 1))
End Sub



'Returns a string with all unprintable characters removed
'Stops at the first null character
Function Clean(Dirty As String) As String
    Dim i As Integer
    Dim Character As Byte
    
    For i = 1 To Len(Dirty)
        Character = Asc(Mid$(Dirty, i, 1))
        
        Select Case Character
        Case 0
            Exit For
        Case 9
            Clean = Clean & "<TAB>"
        Case 10
            Clean = Clean & "<LF>"
        Case 13
            Clean = Clean & "<CR>"
        Case 26
            Clean = Clean & "<SUB>"
        Case 32 To 127
            Clean = Clean & Chr$(Character)
        Case Else
            Clean = Clean & "<" & Character & ">"
        End Select
    Next
End Function


'Formats and prints the specified text to the output file
Function AddText(ByRef Text As String, _
                 ByVal desc As String, _
                 Optional ByVal Val1 As String = vbNullString, _
                 Optional ByVal Val2 As String = vbNullString)
    
    If Val2 <> vbNullString Then
        Val2 = "[" & Val2 & "]"
    End If
    
    If Val1 = vbNullString Then
       Text = Text & vbCrLf & desc & vbCrLf
    Else
        Text = Text & Format(desc, "!@@@@@@@@@@@@@@@@@@") & Clean(Val1) & " " & Val2 & vbCrLf
    End If
    
End Function

'Prints the printable characters from a string to the debug window,
'with the decimal ASCII value of each character (printable or not) on the next line
Sub HexDump(Text As String, Optional LineNo As Long)

    Dim i As Integer
    Dim Character As Byte
    Dim SpacedText As String
    Dim HexText As String
    Dim LogFile As Long
    Dim OutputText As String
        
    For i = 1 To Len(Text)
        Character = Asc(Mid$(Text, i, 1))
        If Character >= 32 And Character <= 126 Then
            SpacedText = SpacedText & Chr$(Character)
        Else
            SpacedText = SpacedText + Chr$(127)
        End If
        SpacedText = SpacedText + Space$(3)
        HexText = HexText & Format(Character, "000 ")
    Next
    Debug.Print SpacedText
    Debug.Print HexText

'    Logfile = FreeFile()
'    Open "c:\output.txt" For Append As Logfile
'
'    OutputText = LineNo & ": " & SpacedText
'    Print #Logfile, OutputText
'
'    OutputText = LineNo & ": " & HexText & vbCrLf
'    Print #Logfile, OutputText
'
'    Close Logfile
    
End Sub



'Copies the bits from a double directly into an 8-byte integer (Currency data type)
'This is used to read the Citect Trend's invalid or gated values that are valid as long
'integers, but invalid as Double values.
'
Public Function CastDoubleAsCurrency(ByVal EightByteVal As Double) As Currency

    Dim DoubleVal As udtSample8
    Dim CurrencyVal As udtSampleCurrency

    DoubleVal.Value = EightByteVal
    LSet CurrencyVal = DoubleVal
    
    CastDoubleAsCurrency = CurrencyVal.Value

End Function


'Combine 2 UINTS into one LONG
Function CUIntsToLong(ByVal LeftInt As Long, ByVal RightInt As Long) As Long
    CUIntsToLong = LeftInt
    MemCopy ByVal (VarPtr(CUIntsToLong) + 2), RightInt, 2
End Function
 


'Returns a string up to the first null in the argument string
'Used to strip off characters after the first null in a fixed length string
Function ToNull(ByVal InputText As String) As String
    Dim NullPos As Long
    NullPos = InStr(InputText, Chr$(0))
    If NullPos > 0 Then
        ToNull = Left$(InputText, NullPos - 1)
    Else
        ToNull = InputText
    End If
End Function


Sub InsertionSort(SortArray() As Date, SyncArray() As Long, Optional Start As Long = 0, Optional Finish As Long = 0)
    
    Dim i As Long
    Dim J As Long
    Dim SortTemp
    Dim SyncTemp
    
    If (Start = 0) And (Finish = 0) Then
        Start = LBound(SortArray)
        Finish = UBound(SortArray)
    End If

    For i = Start + 1 To Finish
        SortTemp = SortArray(i)
        SyncTemp = SyncArray(i)
        For J = i - 1 To 1 Step -1
            If SortTemp >= SortArray(J) Then Exit For
            SortArray(J + 1) = SortArray(J)
            SyncArray(J + 1) = SyncArray(J)
        Next J
        SortArray(J + 1) = SortTemp
        SyncArray(J + 1) = SyncTemp
    Next i
End Sub


'Add tabstops to a listbox. Each tab unit is about 1/4 of a character in width
'Each tab value is the distance from the left edge
'E.g. SetListBoxTabs lstData, 120, 150, 175
Public Sub SetListboxTabs(lstListBox As ListBox, ParamArray TabStops() As Variant)
    Dim i As Long
    Dim min As Long
    Dim max As Long
    Dim lngTabs() As Long
    
    min = LBound(TabStops)
    max = UBound(TabStops)
    
    ReDim lngTabs(min To max)
    
    For i = min To max
        lngTabs(i) = TabStops(i)
    Next i
    
    SendMessage lstListBox.hwnd, LB_SETTABSTOPS, 0&, ByVal 0&   'clear existing tabs
    SendMessage lstListBox.hwnd, LB_SETTABSTOPS, max + 1, lngTabs(0)
End Sub


