VERSION 5.00
Begin VB.Form frmStatusBar 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Progress"
   ClientHeight    =   1680
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   4680
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   1680
   ScaleWidth      =   4680
   ShowInTaskbar   =   0   'False
   StartUpPosition =   1  'CenterOwner
   Begin VB.CommandButton cmdCancel 
      Caption         =   "Cancel"
      Height          =   375
      Left            =   1800
      TabIndex        =   2
      Top             =   1200
      Width           =   1095
   End
   Begin VB.PictureBox picStatusBar 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00FFFFFF&
      DrawMode        =   10  'Mask Pen
      FillStyle       =   0  'Solid
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FF0000&
      Height          =   255
      Left            =   120
      ScaleHeight     =   195
      ScaleMode       =   0  'User
      ScaleWidth      =   100
      TabIndex        =   0
      Top             =   840
      Width           =   4455
   End
   Begin VB.Label lblProgress 
      Height          =   255
      Index           =   2
      Left            =   120
      TabIndex        =   4
      Top             =   600
      Width           =   4455
   End
   Begin VB.Label lblProgress 
      Height          =   255
      Index           =   1
      Left            =   120
      TabIndex        =   3
      Top             =   360
      Width           =   4455
   End
   Begin VB.Label lblProgress 
      Caption         =   "Operation in progress..."
      Height          =   255
      Index           =   0
      Left            =   120
      TabIndex        =   1
      Top             =   120
      Width           =   4455
   End
End
Attribute VB_Name = "frmStatusBar"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'Status Bar
'
'Call frmStatusBar.Show to display the status bar form,
'then call Update() to update the progress and check for user cancellation
'Unload frmStatusBar when done, or when user cancells
'
'Form is always on top
'Use the text property to set the progress labels
'Use the Title property to set the Titlebar (default is App.Title)

Private mCancel As Long

Private Declare Function BitBlt Lib "gdi32" (ByVal hDestDC As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal dwRop As Long) As Long
Private Declare Function SetWindowPos Lib "user32" (ByVal hwnd As Long, ByVal hWndInsertAfter As Long, ByVal x As Long, ByVal y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long

Private Const SWP_NOSIZE = &H1
Private Const SWP_NOMOVE = &H2
Private Const SWP_NOACTIVATE = &H10
Private Const HWND_TOPMOST = -1


'Sets text for labels 0 - 2. Label 0 has default text but 1 and 2 are blank by default
Public Property Let Text(Index As Long, Text As String)
    lblProgress(Index).Caption = Text
End Property

Public Property Get Text(Index As Long) As String
    Text = lblProgress(Index).Caption
End Property


Public Property Let Title(Text As String)
    Me.Caption = Text
End Property

Public Property Get Title() As String
    Title = Me.Caption
End Property

Public Function Update(ByVal Percent As Long, Optional ByRef Cancel As Long)

    Const SRCCOPY = &HCC0020
    
    Dim PercentLabel As String
    Dim r As Long
   
    Select Case Percent
        Case Is < 0
            Percent = 0
        Case Is > 100
            Percent = 100
        Case Else
            '% specified is OK
    End Select
    
    PercentLabel = CStr(Percent) & "%"
    
    With picStatusBar
        .Cls
        .CurrentX = (.ScaleWidth - .TextWidth(PercentLabel$)) \ 2
        .CurrentY = (.ScaleHeight - .TextHeight(PercentLabel)) \ 2
        picStatusBar.Print PercentLabel     'not sure why these lines won't work using WITH statement to eliminate 'picStatusBar'
        picStatusBar.Line (0, 0)-(Percent, picStatusBar.ScaleHeight), picStatusBar.ForeColor, BF
        r = BitBlt(.hDC, 0, 0, .ScaleWidth, .ScaleHeight, .hDC, 0, 0, SRCCOPY)
    End With
    
    DoEvents
    
    Cancel = mCancel
    mCancel = vbOK
    
End Function

Private Sub cmdCancel_Click()
    mCancel = vbCancel
End Sub

Private Sub Form_Load()
    Title = App.Title
End Sub

Private Sub Form_Resize()
    'Always on top
    SetWindowPos Me.hwnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE Or SWP_NOSIZE Or SWP_NOACTIVATE
End Sub
