VERSION 5.00
Object = "{3B7C8863-D78F-101B-B9B5-04021C009402}#1.2#0"; "RICHTX32.OCX"
Begin VB.Form frmReader 
   Caption         =   "Citect Trend Reader"
   ClientHeight    =   7830
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   11520
   DrawMode        =   14  'Copy Pen
   Icon            =   "Reader.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   7830
   ScaleWidth      =   11520
   StartUpPosition =   2  'CenterScreen
   Begin RichTextLib.RichTextBox rtfDescription 
      Height          =   5895
      Left            =   120
      TabIndex        =   14
      Top             =   1440
      Width           =   7335
      _ExtentX        =   12938
      _ExtentY        =   10398
      _Version        =   393217
      Enabled         =   -1  'True
      ScrollBars      =   3
      TextRTF         =   $"Reader.frx":08CA
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Courier New"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.PictureBox picSplitter 
      Appearance      =   0  'Flat
      BorderStyle     =   0  'None
      DragMode        =   1  'Automatic
      FillStyle       =   0  'Solid
      ForeColor       =   &H80000008&
      Height          =   6255
      Left            =   7440
      MousePointer    =   9  'Size W E
      ScaleHeight     =   6255
      ScaleWidth      =   75
      TabIndex        =   11
      TabStop         =   0   'False
      Top             =   1440
      Width           =   80
   End
   Begin VB.ListBox lstData 
      Height          =   5910
      Left            =   7560
      TabIndex        =   4
      Top             =   1440
      Width           =   3855
   End
   Begin VB.Frame fraFile 
      Height          =   1215
      Left            =   120
      TabIndex        =   5
      Top             =   120
      Width           =   11295
      Begin VB.CheckBox chkHideInvalid 
         Caption         =   "Hide &Invalid Samples"
         Height          =   255
         Left            =   2280
         TabIndex        =   15
         Top             =   720
         Value           =   1  'Checked
         Width           =   2415
      End
      Begin VB.CommandButton cmdSave 
         Caption         =   "&Save"
         Height          =   375
         Left            =   9120
         TabIndex        =   13
         Top             =   720
         Visible         =   0   'False
         Width           =   975
      End
      Begin VB.TextBox txtfile 
         Height          =   315
         Left            =   960
         TabIndex        =   12
         Top             =   240
         Width           =   9015
      End
      Begin VB.CommandButton cmdHelp 
         Caption         =   "&Help"
         Height          =   375
         Left            =   10200
         TabIndex        =   3
         Top             =   720
         Width           =   975
      End
      Begin VB.CheckBox chkShowData 
         Caption         =   "&Show Data"
         Height          =   255
         Left            =   960
         TabIndex        =   1
         Top             =   720
         Value           =   1  'Checked
         Width           =   1215
      End
      Begin VB.CommandButton cmdOpen 
         Caption         =   "&Open..."
         Default         =   -1  'True
         Height          =   375
         Left            =   10200
         TabIndex        =   2
         Top             =   240
         Width           =   975
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Trend File:"
         Height          =   195
         Left            =   120
         TabIndex        =   0
         Top             =   240
         Width           =   750
      End
   End
   Begin VB.Frame fraNavigation 
      BorderStyle     =   0  'None
      Height          =   255
      Left            =   10440
      TabIndex        =   6
      Top             =   7440
      Visible         =   0   'False
      Width           =   975
      Begin VB.Label lblLast 
         AutoSize        =   -1  'True
         Caption         =   ">|"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   240
         Left            =   720
         TabIndex        =   10
         ToolTipText     =   "Last page of samples"
         Top             =   0
         Visible         =   0   'False
         Width           =   150
      End
      Begin VB.Label lblNext 
         AutoSize        =   -1  'True
         Caption         =   ">"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   240
         Left            =   480
         TabIndex        =   9
         ToolTipText     =   "Next page of samples"
         Top             =   0
         Visible         =   0   'False
         Width           =   105
      End
      Begin VB.Label lblPrev 
         AutoSize        =   -1  'True
         Caption         =   "<"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   240
         Left            =   240
         TabIndex        =   8
         ToolTipText     =   "Previous page of samples"
         Top             =   0
         Visible         =   0   'False
         Width           =   105
      End
      Begin VB.Label lblFirst 
         AutoSize        =   -1  'True
         Caption         =   "|<"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   240
         Left            =   0
         TabIndex        =   7
         ToolTipText     =   "First page of samples"
         Top             =   0
         Visible         =   0   'False
         Width           =   150
      End
   End
End
Attribute VB_Name = "frmReader"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Option Compare Text

Const Margin = 120  'Margin for form graphic object placement

Dim ListIndex As Long

Dim SplitterPos As Single   'Splitter position (fraction of the window width)

Private Sub chkShowData_Click()
    chkHideInvalid.Enabled = (chkShowData.Value = vbChecked)
End Sub

Private Sub cmdHelp_Click()
    frmHelp.Show
End Sub

'9/1/04 Added 'All Files' choice, removed common dialog OCX dependency
Private Sub cmdOpen_Click()
    Dim FileName As String
    
    FileName = FileOpenDialog(Folder:=txtfile.Text, _
                              Filter:="All Trend Files|*.HST;*.0??;*.1??;*.2??|" _
                                      + "History Files (*.HST)|*.HST|" _
                                      + "Data Files (*.nnn)|*.0??;*.1??;*.2??|" _
                                      + "All Files|*.*|", _
                              Flags:=OFN_FILEMUSTEXIST + OFN_HIDEREADONLY + OFN_PATHMUSTEXIST)
    If FileName <> "" Then
        txtfile.Text = FileName
        ListIndex = 1
        OpenFile
    End If
    
End Sub

'9/1/04 Added error handler and reset cursor from hourglass after an error
Sub OpenFile()

    Dim FileName As String
    Dim FileNo As Long
    Dim MaxIndex As Long
    
    On Error GoTo ErrorHandler
    
    Me.MousePointer = vbHourglass
    
    lstData.Clear
    FileName = txtfile.Text
    
    DoEvents
    
    If FileExists(FileName) = False Then
        MsgBox "File does not exist:" & FileName, vbCritical + vbOKOnly
        GoTo Cleanup
    End If
    
    FileNo = FreeFile()
       
    Open FileName For Binary As FileNo
    
    rtfDescription.Text = GetTrendHeader(FileName, FileNo)
    
    If rtfDescription.Text <> vbNullString Then
        If (GetExtension(FileName) <> "hst") Then
            cmdSave.Visible = False
            If chkShowData.Value = vbChecked Then
                MaxIndex = GetTrendData(lstData, ListIndex, FileNo, HideInvalid:=chkHideInvalid)
                frmStatusBar.Hide
            End If
        Else 'HST file
            cmdSave.Visible = True
        End If
    End If
    
    Close FileNo
    
    SetBrowseVisibility MaxIndex
    
Cleanup:
    Me.MousePointer = vbDefault
    Exit Sub

ErrorHandler:
    MsgBox "Error #" & Err.Number & " " & Err.Description
    GoTo Cleanup
    
End Sub


Sub SetBrowseVisibility(MaxIndex As Long)

    If MaxIndex = 0 Then
        fraNavigation.Visible = False
        Exit Sub
    Else
        fraNavigation.Visible = True
    End If
    
    lblFirst.Visible = True
    lblPrev.Visible = True
    lblNext.Visible = True
    lblLast.Visible = True
    
    If ListIndex = -1 Then
        lblLast.Visible = False
    Else
        If ListIndex + 32768 - 1 > MaxIndex Then
            lblNext.Visible = False
            lblLast.Visible = False
        End If
        
        If ListIndex = 1 Then
            lblFirst.Visible = False
            lblPrev.Visible = False
        End If
    End If
End Sub


Private Sub cmdSave_Click()

    Dim SaveTo As String
    
    If txtfile.Text <> vbNullString Then
        SaveTo = DropExtension(txtfile.Text) & ".csv"
        If FileExists(SaveTo) Then
            If MsgBox("File already exists. Do you wish to overwrite it?", vbOKCancel) = vbOK Then
                DeleteFile SaveTo
            Else
                Exit Sub
            End If
        End If
    End If
    
    ExportTrendFiles SaveTo, Me
    
End Sub

Private Sub Form_Load()

    txtfile.Text = GetSetting("Trend Reader", "Settings", "LastFile")
    chkHideInvalid.Value = GetSetting("Trend Reader", "Settings", "HideInvalid", vbUnchecked)
    ListIndex = 1
    SetListboxTabs lstData, 130, 150
    SetRichTextBoxWordWrap rtfDescription, False
    
End Sub


Private Sub Form_Resize()

    If SplitterPos = 0 Then SplitterPos = 0.47

    If Me.WindowState <> vbMinimized Then
        'Minimum width
        If Me.ScaleWidth < 6855 Then
            Me.Width = 6855
        End If
                
        'Move the splitter left when the form width is changed
        picSplitter.Left = Me.ScaleWidth * SplitterPos
        
'        If Me.ScaleWidth < picSplitter.Left + picSplitter.Width + (Margin * 2) Then
'            picSplitter.Left = Me.ScaleWidth - picSplitter.Width - (Margin * 2)
'        End If

        'Minimum height
        If Me.ScaleHeight < 3000 Then
            Me.Height = 3000
        End If
        
        fraFile.Width = Me.ScaleWidth - (Margin * 2)
        FraFile_Resize

        picSplitter.Top = fraFile.Top + fraFile.Height
        picSplitter.Height = Me.ScaleHeight - picSplitter.Top
                
        rtfDescription.Width = picSplitter.Left - Margin
        rtfDescription.Height = Me.ScaleHeight - (rtfDescription.Top + Margin)
        
        lstData.Left = picSplitter.Left + picSplitter.Width
        lstData.Width = Me.ScaleWidth - (picSplitter.Left + picSplitter.Width) - Margin
        fraNavigation.Left = lstData.Left + lstData.Width - fraNavigation.Width
        lstData.Height = rtfDescription.Height - fraNavigation.Height - Margin
        fraNavigation.Top = lstData.Top + lstData.Height + Margin
        
    End If
End Sub

Private Sub FraFile_Resize()
    cmdOpen.Left = fraFile.Width - cmdOpen.Width - Margin
    cmdHelp.Left = cmdOpen.Left
    cmdSave.Left = cmdHelp.Left - cmdSave.Width - Margin
    txtfile.Width = cmdOpen.Left - txtfile.Left - Margin
End Sub

Private Sub Form_Unload(Cancel As Integer)
    SaveSetting "Trend Reader", "Settings", "LastFile", txtfile.Text
    SaveSetting "Trend Reader", "Settings", "HideInvalid", chkHideInvalid.Value
    End
End Sub


Private Function UIntToLong(UInt As Integer) As Long
    If UInt < 0 Then
        UIntToLong = UInt + 65536
    Else
        UIntToLong = UInt
    End If
End Function

Private Sub lblFirst_Click()
    ListIndex = 1
    OpenFile
End Sub

Private Sub lblLast_Click()
    ListIndex = -1
    OpenFile
End Sub

Private Sub lblNext_Click()
    ListIndex = ListIndex + 32768
    OpenFile
End Sub

Private Sub lblPrev_Click()
    ListIndex = ListIndex - 32768
    If ListIndex < 1 Then ListIndex = 1
    OpenFile
End Sub

Private Sub lstData_DragDrop(Source As Control, x As Single, y As Single)
    'Resize with splitterbar
    If x < lstData.Width Then
        picSplitter.Left = x + lstData.Left - picSplitter.Width
        SplitterPos = picSplitter.Left / Me.ScaleWidth
        Form_Resize
    End If
End Sub


Private Sub rtfDescription_DragDrop(Source As Control, x As Single, y As Single)
    'Resize with splitter bar
    If x > 0 Then
        picSplitter.Left = x   'Move splitter bar.
        SplitterPos = picSplitter.Left / Me.ScaleWidth
        Form_Resize
    End If
End Sub
 
