VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsHSTMaster"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Title As String          'Title of the file (ASCII). It contains information, such as file version, type, start time and logging name.
Public ID As String                'ID for Citect files. It is set to "CITECT".
Public FileType As Integer            'Type of the Citect file. It is set to 0, which is FILE_TYPE_TREND.
Public Version As TrendVersionEnum    'Version number of the trends. (3 or 4 depending on the storage method of the Trend)
Public Mode As Long                    'Indicates the mode of the MASTER file. (For future use. Currently it is set to 0.)
Public History As Integer             'Maximum Number of history files to be created. (not including AddOn)
Public nFiles As Integer               'Number of history files currently created. (not including AddOn)
Public NextFile As Integer                 'Next history file number. Internal use only, users MUST NOT use this entry to get the next history file.
Public AddOn As Integer               'Shows the number of history files added onto the system through user functions. User can add old (backed up) history files to the system temporarily by using TrnAddHistory() and TrnDelHistory().

Private Type MasterHeader
    Title As String * 128       'Title of the file (ASCII). It contains information, such as file version, type, start time and logging name.
    ID As String * 8            'ID for Citect files. It is set to "CITECT".
    FileType As Integer         'Type of the Citect file. It is set to 0, which is FILE_TYPE_TREND.
    Version As Integer          'Version number of the trends. (3 or 4 depending on the storage method of the Trend)
    Alignment1 As String * 4    'alignment for 16 bytes
    Mode As Long                'Indicates the mode of the MASTER file. (For future use. Currently it is set to 0.)
    History As Integer          'Maximum Number of history files to be created. (not including AddOn)
    nFiles As Integer           'Number of history files currently created. (not including AddOn)
    Next As Integer             'Next history file number. Internal use only, users MUST NOT use this entry to get the next history file.
    AddOn As Integer            'Shows the number of history files added onto the system through user functions. User can add old (backed up) history files to the system temporarily by using TrnAddHistory() and TrnDelHistory().
    Alignment2 As String * 20   'Alignment for 16 bytes
End Type

Public Function Load(FileNo As Long)

    Dim MasterHdr As MasterHeader
    
    Get FileNo, 1, MasterHdr
 
    With MasterHdr
        Title = .Title
        ID = .ID
        FileType = .FileType
        Version = .Version
        Mode = .Mode
        History = .History
        nFiles = .nFiles
        NextFile = .Next
        AddOn = .AddOn
    End With
End Function

Public Function Save(FileNo As Long)
    Dim MasterHdr As MasterHeader
    
    With MasterHdr
        .Title = Title
        .ID = ID
        .FileType = FileType
        .Version = Version
        .Mode = Mode
        .History = History
        .nFiles = nFiles
        .Next = NextFile
        .AddOn = AddOn
    End With

    Put FileNo, 1, MasterHdr

End Function
