Attribute VB_Name = "FileTools"
Option Explicit

Declare Function DeleteFileA Lib "kernel32" (ByVal lpFileName As String) As Long

Declare Function GetDiskFreeSpaceEx Lib "kernel32" Alias "GetDiskFreeSpaceExA" _
        (ByVal lpRootPathName As String, _
        lpFreeBytesAvailableToCaller As Currency, _
        lpTotalNumberOfBytes As Currency, _
        lpTotalNumberOfFreeBytes As Currency) As Long


'Return the extension from a path/filename
Function GetExtension(FileName As String) As String

    Dim DotPos As Long
    DotPos = InStrRev(FileName, ".")
    
    If DotPos > 0 Then
        GetExtension = Mid$(FileName, DotPos + 1)
    Else
        GetExtension = vbNullString
    End If
End Function


'Return True if a path\file exists, false if it doesn't
Function FileExists(ByVal FileName As String) As Boolean
    FileExists = (FileName <> vbNullString) And (Dir(FileName) <> vbNullString)
End Function



'Return the file extension from a path & filename
Function ExtractFileExt(FileName As String) As String
    Dim Position As Long
    
    Position = InStrRev(FileName, ".")
    
    ExtractFileExt = Right$(FileName, Len(FileName) - Position)
End Function

'Deletes the specified file and returns True (success) or False (invalid file, insufficient privileges, file locked)
Function DeleteFile(ByVal FileName As String) As Boolean

    DeleteFile = DeleteFileA(FileName)

End Function


'Return the drive\folder from a path & filename
Function ExtractDirName(PathName As String) As String
    Dim X As Integer
    
    X = InStrRev(PathName, "\", Len(PathName) - 1, Compare:=vbTextCompare)
    ExtractDirName = Left$(PathName, X - 1)
End Function


'Return the file name from a path & filename
Function ExtractFileName(PathName As String) As String
    Dim Position As Long
    
    Position = InStrRev(PathName, "\", Compare:=vbTextCompare)
    
    ExtractFileName = Right$(PathName, Len(PathName) - Position)
End Function


'Creates any number of nested folders from a string like "c:\foo\bar\foobar"
Sub CreatePath(ByVal DirName As String)
   
    Dim NewLen As Long
    Dim DirLen As Long
    Dim MaxLen As Long
    
    NewLen = 4
        
    DirName = TrailingBackslash(DirName)
    
    MaxLen = Len(DirName)
    
    On Error Resume Next    'Ignore MkDir's errors if directory exists
    
    Do
        DirLen = InStr(NewLen, DirName, "\")
        MkDir Left$(DirName, DirLen - 1)
        NewLen = DirLen + 1
    Loop While NewLen < MaxLen
    
End Sub


'Adds a trailing backslash to a path (if it doesn't already have one)
Function TrailingBackslash(ByVal Path As String) As String
    
    If Right$(Path, 1) <> "\" Then Path = Path & "\"
    TrailingBackslash = Path

End Function


'Drops the .ext from the end of a string like drive:\path\filename.ext
'Returns the shortened path\filename
Function DropExtension(FileName As String)
    Dim Count As Long
    Dim DotPos As Long
    Dim BackslashPos As Long
    
    DotPos = InStrRev(FileName, ".")
    BackslashPos = InStrRev(FileName, "\")
    
    If (DotPos > 0) And (DotPos > BackslashPos) Then
        DropExtension = Left$(FileName, DotPos - 1)
    Else    'No extension found
        DropExtension = FileName
    End If
    
End Function


'Gets the number of KB of free space on the specified drive.
'
'Arguments: Drive   May be any path ("c:\", "c:\temp", "x:\", "\\server\drive\", etc)
'
'Return:    Free space in KB. If drive was invalid, -1 is returned
'
'Notes:     Requires Win95 OSR2 or higher or NT 3.51 or higher. Takes into account user quotas
'
Function GetFreeDiskSpaceKB(Path As String) As Long

    Dim Result As Boolean
    Dim FreeAvailableBytes As Currency      'Takes into account Win2K user quotas
    Dim TotalAvailableBytes As Currency     'Takes into account Win2K user quotas
    Dim FreeBytes As Currency
    Dim FreeKB As Long
        
    Result = GetDiskFreeSpaceEx(Path, FreeAvailableBytes, TotalAvailableBytes, FreeBytes)
    
    If Result = True Then
        'Multiply by 10000 to convert currency to double-long int. Divide by 1024 for KB
        FreeKB = FreeAvailableBytes / 1024 * 10000
    Else
        FreeKB = -1
    End If
    
    GetFreeDiskSpaceKB = FreeKB
    
End Function


'Public Declare Function GetTempPath Lib "kernel32" Alias "GetTempPathA" (ByVal nBufferLength As Long, ByVal lpBuffer As String) As Long
'
'nBufferLength  Long (Length of the lpBuffer -- setup before use)
'lpBuffer  String (Buffer to hold result -- path to Windows System Directory)
'
'Note: Returns actual length of string, even if lpBuffer is too short.
'


'Public Declare Function GetTempFileName Lib "kernel32" Alias "GetTempFileNameA" (ByVal lpszPath As String, ByVal lpPrefixString As String, ByVal wUnique As Long, ByVal lpTempFileName As String) As Long
'
'lpszPath  String (Directory to use -- usually determined by the GetTempPath function)
'lpPrefixString  String (File Prefix to use -- uses first 3 characters)
'wUnique  Long (A starting point for a number to add to the end of the prefix. If zero, a random number is generated as the starting point.
'lpTempFileName  String (a buffer to hold the temp file name. It should be at least Max_Path characters in length.
'
'Note: Returns zero on error, or the wUnique number used to generate the file name, or the actual value if the wUnique parameter was zero.

