Attribute VB_Name = "DateTimeTools"
Option Explicit


'Convert VB time variable to a formatted time like "12/24/2003 11:59:59.100 PM GMT"
' 1/6/05 Added MS argument
Function FormatTime(Time As Variant, Optional ByVal IsGMT As Long = True, Optional ByVal MS As Long = -1) As String
    Dim TimeVB As Date
    
    FormatTime = Format(CVbTime(Time), "mm/dd/yyyy Hh:Nn:Ss")
    If TypeName(Time) = "Currency" Then
        FormatTime = FormatTime & "." & Format(CInt64ToMS(Time), "000")
    ElseIf MS <> -1 Then
        FormatTime = FormatTime & "." & Format(MS, "000")
    End If
      
    If IsGMT = True Then FormatTime = FormatTime & " GMT"

End Function

'Convert Citect, Int64, or VB time into Int64 format
Function CInt64Time(Time As Variant, Optional ByVal MS As Long = 0) As Currency

    Select Case TypeName(Time)
    Case "Currency"
        CInt64Time = Time
    Case "Date"
        CInt64Time = CVbToInt64(Time)
    Case "Long"
        CInt64Time = CCitectToInt64(Time, MS)
    End Select

End Function

'Convert Citect, Int64, or VB time into VB Date format
Function CVbTime(Time As Variant) As Date

    Select Case TypeName(Time)
    Case "Currency"
        CVbTime = CInt64ToVB(Time)
    Case "Date"
        CVbTime = Time
    Case "Long"
        CVbTime = CCitectToVB(Time)
    End Select

End Function

'Convert Citect, Int64, or VB time into Citect format
Function CCitectTime(Time As Variant) As Long

    Select Case TypeName(Time)
    Case "Currency"
        CCitectTime = CInt64ToCitect(Time)
    Case "Date"
        CCitectTime = CVbToCitect(Time)
    Case "Long"
        CCitectTime = Time
    End Select

End Function


'Retrieve the MS from an Int64 time value
Function CInt64ToMS(ByVal Int64 As Currency) As Long
    CInt64ToMS = Int64 - (Fix(Int64 / 1000) * 1000)
End Function

'Convert 32-bit Citect date to VB date format
Private Function CCitectToVB(ByVal CitectDate As Double) As Date
    Const CitectToVBOffset As Long = 25569
    
    CCitectToVB = (CitectDate / SecondsPerDay) + CitectToVBOffset

End Function

'Convert VB date to 32-bit Citect date format
Private Function CVbToCitect(ByVal VbDate As Date) As Long
    Const VbToCitectOffset As Currency = -2209161600#

    CVbToCitect = (VbDate * SecondsPerDay) + VbToCitectOffset

End Function

'Convert 64-bit Citect date to 32-bit Citect date format
Private Function CInt64ToCitect(ByVal Int64 As Currency) As Long
    Const Int64ToCitectOffset As Currency = 11644473600@
    
    CInt64ToCitect = (Int64 / 1000) - Int64ToCitectOffset
End Function

'Convert 32-bit Citect date to 64-bit Citect date format
Private Function CCitectToInt64(ByVal CitectDate As Long, Optional ByVal MS As Long = 0) As Currency
    Const Int64ToCitectOffset As Currency = 11644473600@
    
    CCitectToInt64 = ((CCur(CitectDate) + Int64ToCitectOffset) * 1000) + MS   'Adjust to Citect origin and Convert to ns
End Function

'Convert 64-bit Citect date to VB date format
'Modified 1/18/05 Dropped MS so it's not rounded
Private Function CInt64ToVB(ByVal curInt64 As Currency) As Date
    Const Int64ToVBOffset As Double = -109205#
    
    Dim VBTime As Double
    Dim MS As Currency
        
    MS = CInt64ToMS(curInt64)
    VBTime = (curInt64 - MS) / 1000          'convert to secs
    VBTime = VBTime / SecondsPerDay     'Convert to days
    VBTime = VBTime + Int64ToVBOffset   'offset to vb origin
    
    CInt64ToVB = VBTime
End Function

'Convert VB to Int64 date format
Private Function CVbToInt64(ByVal VbDate As Date) As Currency
    Const VbToInt64Offset As Currency = 9435312000000@
    
    CVbToInt64 = (VbDate * SecondsPerDay * 1000) + VbToInt64Offset
    
End Function

             
'Public Declare Sub GetSystemTime Lib "kernel32" (lpSystemTime As SYSTEMTIME)
'Public Declare Sub GetLocalTime Lib "kernel32" (lpSystemTime As SYSTEMTIME)
'
'Public Type SYSTEMTIME             'Windows time structure
'   wYear As Integer
'   wMonth As Integer
'   wDayOfWeek As Integer
'   wDay As Integer
'   wHour As Integer
'   wMinute As Integer
'   wSecond As Integer
'   wMilliseconds As Integer
'End Type
'
'Return offset of the local time from GMT (in hours)
'Dick Campbell - Citect KB Q2008
'
'Function GmtOffset() As Long
'    Dim trLocal As SYSTEMTIME
'    Dim trSystem As SYSTEMTIME
'    Dim tzSystem As Double
'    Dim tzLocal As Double
'
'    Static Offset As Long
'    Static OffsetCalculated As Boolean
'
'    If OffsetCalculated = False Then
'
'        GetSystemTime trSystem
'
'        With trSystem
'            tzSystem = DateSerial(.wYear, .wMonth, .wDay) + TimeSerial(.wHour, .wMinute, .wSecond)
'        End With
'
'        GetLocalTime trLocal
'
'        With trLocal
'            tzLocal = DateSerial(.wYear, .wMonth, .wDay) + TimeSerial(.wHour, .wMinute, .wSecond)
'        End With
'
'        Offset = Round(24 * (tzLocal - tzSystem), 0)
'
'        OffsetCalculated = True
'
'    End If
'
'    GmtOffset = Offset
'
'End Function

