VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsDataHeader"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Title As String                  'ASCII title of the file. It contains information, such as, file version, type, start time and logging name.
Public RawZero As Single
Public RawFull As Single
Public EngZero As Single
Public EngFull As Single
Public ID As String                     'ID for Citect files. It is set to "CITECT".
Public FileType As Integer              'Type of the Citect file. It is set to 0, which is FILE_TYPE_TREND.
Public Version As TrendVersionEnum      'Version number of the trends. (equal to 4 for this Storage Method)
Public StartEvNo As String              'Starting Number for events in this history file. (Event Trends only.)
Public LogName As String                'Name of the trend record that owns the history file.
Public Mode As Long                     'Indicates the mode of the history file. (For future use. Currently it is set to 0.)
Public Area As Integer                  '2 The area that has access to the acquired data.
Public Priv As Integer                  'The access rights required to execute the command.
Public HistoryType As HistoryTypeEnum   'History File Type. Set to 0 for Periodic and Periodic_Event Trends. Set to 4 for Event Trends.
Public SamplePeriod As Double           'Sample period of logging (in seconds)
Public SamplePeriodRaw As Long
Public sEngUnits As String              'Units of scales. (Set to the units of the trend record.)
Public Format As Long                   'Format of scales. (Set to the format of the trend record.)
Public StartTime As New clsTimes        'The earliest time that a sample can have and be placed in this file. (in number of 100 nanosecond time units since 1st of January, 1601)
Public EndTime As New clsTimes          'For Periodic Trends the EndTime is always set to the latest possible sample time that can be put into this file. For Event Trends the EndTime is the time of the newest sample stored in the file (one less than the StartTime if there are no samples in the file). (in number of 100 nanosecond time units since 1st of January, 1601)
Public DataLength As Long               'Shows the number of data items. DataLength = (File Size - HeaderSize) / 8
Public FilePointer As Long              'The location of the newest sample in the file, in number of samples from the start of the data portion of the file.(Periodic Trends only).
Public EndEvNo As String                'The event number of the next sample after the last one in this file. (Event Trends only)

Public FileSize As Long                 'Size of the file (bytes) as reported by windows
Public HeaderSize As Long               'Size of the header (bytes) for this data file

Private Type DataHeader8
    Title As String * 112       'ASCII title of the file. It contains information, such as, file version, type, start time and logging name.
    RawZero As Single
    RawFull As Single
    EngZero As Single
    EngFull As Single
    ID As String * 8            'ID for Citect files. It is set to "CITECT".
    FileType As Integer         'Type of the Citect file. It is set to 0, which is FILE_TYPE_TREND.
    Version As Integer          'Version number of the trends. (equal to 4 for this Storage Method)
    StartEvNo As Currency       'Starting Number for events in this history file. (Event Trends only.)
    Alignment1 As String * 12   'For 16 bytes
    LogName As String * 64      'Name of the trend record that owns the history file.
    Mode As Long                'Indicates the mode of the history file. (For future use. Currently it is set to 0.)
    Area As Integer             '2 The area that has access to the acquired data.
    Priv As Integer             'The access rights required to execute the command.
    HistoryType As Integer      'History File Type. Set to 0 for Periodic and Periodic_Event Trends. Set to 4 for Event Trends.
    SamplePeriod As Long        'Sample period of logging (in milliseconds)
    sEngUnits As String * 8     'Units of scales. (Set to the units of the trend record.)
    Format As Long              'Format of scales. (Set to the format of the trend record.)
    StartTime As Currency       'The earliest time that a sample can have and be placed in this file. (in number of 100 nanosecond time units since 1st of January, 1601)
    EndTime As Currency         'For Periodic Trends the EndTime is always set to the latest possible sample time that can be put into this file. For Event Trends the EndTime is the time of the newest sample stored in the file (one less than the StartTime if there are no samples in the file). (in number of 100 nanosecond time units since 1st of January, 1601)
    DataLength As Long          'Shows the number of data items. DataLength = (File Size - HeaderSize) / 8
    FilePointer As Long         'The location of the newest sample in the file, in number of samples from the start of the data portion of the file.(Periodic Trends only).
    EndEvNo As Currency         'The event number of the next sample after the last one in this file. (Event Trends only)
    Alignment2 As String * 6    'for 16 bytes
End Type

Private Type DataHeader8v6
    Title As String * 112       'ASCII title of the file. It contains information, such as, file version, type, start time and logging name.
    RawZero As Single
    RawFull As Single
    EngZero As Single
    EngFull As Single
    ID As String * 8            'ID for Citect files. It is set to "CITECT".
    FileType As Integer         'Type of the Citect file. It is set to 0, which is FILE_TYPE_TREND.
    Version As Integer          'Version number of the trends. (equal to 4 for this Storage Method)
    StartEvNo As Currency           'Starting Number for events in this history file. (Event Trends only.)
    Alignment1 As String * 12   'For 16 bytes
    LogName As String * 80      'Name of the trend record that owns the history file.
    Mode As Long                'Indicates the mode of the history file. (For future use. Currently it is set to 0.)
    Area As Integer             '2 The area that has access to the acquired data.
    Priv As Integer             'The access rights required to execute the command.
    HistoryType As Integer      'History File Type. Set to 0 for Periodic and Periodic_Event Trends. Set to 4 for Event Trends.
    SamplePeriod As Long        'Sample period of logging (in milliseconds)
    sEngUnits As String * 8     'Units of scales. (Set to the units of the trend record.)
    Format As Long              'Format of scales. (Set to the format of the trend record.)
    StartTime As Currency       'The earliest time that a sample can have and be placed in this file. (in number of 100 nanosecond time units since 1st of January, 1601)
    EndTime As Currency         'For Periodic Trends the EndTime is always set to the latest possible sample time that can be put into this file. For Event Trends the EndTime is the time of the newest sample stored in the file (one less than the StartTime if there are no samples in the file). (in number of 100 nanosecond time units since 1st of January, 1601)
    DataLength As Long          'Shows the number of data items. DataLength = (File Size - HeaderSize) / 8
    FilePointer As Long         'The location of the newest sample in the file, in number of samples from the start of the data portion of the file.(Periodic Trends only).
    EndEvNo As Currency         'The event number of the next sample after the last one in this file. (Event Trends only)
    Alignment2 As String * 6    'for 16 bytes
End Type

Private Type DataHeader2
    Title As String * 112       'ASCII title of the file. It contains information, such as, file version, type, start time and logging name.
    RawZero As Single
    RawFull As Single
    EngZero As Single
    EngFull As Single
    ID As String * 8            'ID for Citect files. It is set to "CITECT".
    FileType As Integer         'Type of the Citect file. It is set to 0, which is FILE_TYPE_TREND.
    Version As Integer          'Version number of the trends. (equal to 3 for this Storage Method)
    StartEvNo As Long           'Starting Number for events in this history file. (Event Trends only.)
    LogName As String * 32      'Name of the trend record that owns the history file.
    Mode As Long                'Indicates the mode of the history file. (For future use. Currently it is set to 0.)
    Area As Integer             'The area that has access to the acquired data.
    Priv As Integer             'The access rights required to execute the command.
    HistoryType As Integer      'History File Type. Set to 0 for Periodic and Periodic_Event Trends. Set to 4 for Event Trends.
    SamplePeriod As Long        'Sample period of logging (in milliseconds)
    sEngUnits As String * 8     'Units of scales. (Set to the units of the trend record.)
    Format As Long              'Format of scales. (Set to the format of the trend record.)
    StartTime As Long           'The earliest time that a sample can have and be placed in this file, in seconds since 1970.
    EndTime As Long             'For Periodic Trends the EndTime is always set to the latest possible sample time that can be put into this file. For Event Trends the EndTime is the time of the newest sample stored in the file (one less than the StartTime if there are no samples in the file). Stored as a number of seconds since 1970.
    DataLength As Long          'Shows the number of data items. DataLength = (File Size - HeaderSize) / 2
    FilePointer As Long         'The location of the newest sample in the file, in number of samples from the start of the data portion of the file.(Periodic Trends only).
    EndEvNo As Long             'Event number of the next sample after the last one in this file. (Event Trends only)
    Alignment As String * 2     'for 16 bytes
End Type

Private Type DataHeader2v6
    Title As String * 112       'ASCII title of the file. It contains information, such as, file version, type, start time and logging name.
    RawZero As Single
    RawFull As Single
    EngZero As Single
    EngFull As Single
    ID As String * 8            'ID for Citect files. It is set to "CITECT".
    FileType As Integer         'Type of the Citect file. It is set to 0, which is FILE_TYPE_TREND.
    Version As Integer          'Version number of the trends. (equal to 3 for this Storage Method)
    StartEvNo As Long           'Starting Number for events in this history file. (Event Trends only.)
    LogName As String * 80      'Name of the trend record that owns the history file.
    Mode As Long                'Indicates the mode of the history file. (For future use. Currently it is set to 0.)
    Area As Integer             'The area that has access to the acquired data.
    Priv As Integer             'The access rights required to execute the command.
    HistoryType As Integer      'History File Type. Set to 0 for Periodic and Periodic_Event Trends. Set to 4 for Event Trends.
    SamplePeriod As Long        'Sample period of logging (in milliseconds)
    sEngUnits As String * 8     'Units of scales. (Set to the units of the trend record.)
    Format As Long              'Format of scales. (Set to the format of the trend record.)
    StartTime As Long           'The earliest time that a sample can have and be placed in this file, in seconds since 1970.
    EndTime As Long             'For Periodic Trends the EndTime is always set to the latest possible sample time that can be put into this file. For Event Trends the EndTime is the time of the newest sample stored in the file (one less than the StartTime if there are no samples in the file). Stored as a number of seconds since 1970.
    DataLength As Long          'Shows the number of data items. DataLength = (File Size - HeaderSize) / 2
    FilePointer As Long         'The location of the newest sample in the file, in number of samples from the start of the data portion of the file.(Periodic Trends only).
    EndEvNo As Long             'Event number of the next sample after the last one in this file. (Event Trends only)
    Alignment As String * 2     'for 16 bytes
End Type


Function Load(FileNo As Long)
    
    Const VersionFieldPos = 139   'Byte number of the version field in trend data files
    
    Dim MS As Long
    Dim TimeVal As Currency
    Dim FileVersion As Integer
    
    Dim DataHdr8 As DataHeader8
    Dim DataHdr8v6 As DataHeader8v6
    Dim DataHdr2 As DataHeader2
    Dim DataHdr2v6 As DataHeader2v6

    FileSize = LOF(FileNo)
    
    Get FileNo, VersionFieldPos, FileVersion

    Select Case FileVersion
    Case TwoByteOriginal, TwoBytePreV500, TwoByteV500, TwoByteV531

        Get FileNo, 1, DataHdr2
        
        With DataHdr2
            Title = .Title
            RawZero = .RawZero
            RawFull = .RawFull
            EngZero = .EngZero
            EngFull = .EngFull
            ID = .ID
            FileType = .FileType
            Version = .Version
            StartEvNo = .StartEvNo
            EndEvNo = .EndEvNo
            LogName = .LogName
            Mode = .Mode
            Area = .Area
            Priv = .Priv
            HistoryType = .HistoryType
            DataLength = .DataLength
            FilePointer = .FilePointer
            
            SamplePeriod = .SamplePeriod
            SamplePeriodRaw = .SamplePeriod
            
            If Version >= TwoByteV500 Then
                SamplePeriod = SamplePeriod / 1000
            End If
            
            sEngUnits = .sEngUnits
            Format = .Format
            
            StartTime.Raw = .StartTime
            EndTime.Raw = .EndTime
    
        End With
        
        HeaderSize = Len(DataHdr2)
    
    Case EightByteV531

        Get FileNo, 1, DataHdr8

        With DataHdr8
            
            Title = .Title
            RawZero = .RawZero
            RawFull = .RawFull
            EngZero = .EngZero
            EngFull = .EngFull
            ID = .ID
            FileType = .FileType
            Version = .Version
            StartEvNo = FormatCurrencyAsInt64(.StartEvNo)
            LogName = .LogName
            Mode = .Mode
            Area = .Area
            Priv = .Priv
            HistoryType = .HistoryType
            
            SamplePeriod = .SamplePeriod / 1000
            SamplePeriodRaw = .SamplePeriod
            
            sEngUnits = .sEngUnits
            Format = .Format
            
            StartTime.Raw = .StartTime
            EndTime.Raw = .EndTime
            
            DataLength = .DataLength
            FilePointer = .FilePointer
            EndEvNo = FormatCurrencyAsInt64(.EndEvNo)
        End With
        
        HeaderSize = Len(DataHdr8)
    
    Case TwoByteV600

        Get FileNo, 1, DataHdr2v6
    
        With DataHdr2v6
            Title = .Title
            RawZero = .RawZero
            RawFull = .RawFull
            EngZero = .EngZero
            EngFull = .EngFull
            ID = .ID
            FileType = .FileType
            Version = .Version
            StartEvNo = .StartEvNo
            LogName = .LogName
            Mode = .Mode
            Area = .Area
            Priv = .Priv
            HistoryType = .HistoryType
            
            SamplePeriod = .SamplePeriod / 1000
            SamplePeriodRaw = .SamplePeriod
            
            sEngUnits = .sEngUnits
            Format = .Format
            
            StartTime.Raw = .StartTime
            EndTime.Raw = .EndTime
            
            DataLength = .DataLength
            FilePointer = .FilePointer
            EndEvNo = .EndEvNo
        End With
    
        HeaderSize = Len(DataHdr2v6)
    
    Case EightByteV600

        Get FileNo, 1, DataHdr8v6

        With DataHdr8v6
            Title = .Title
            RawZero = .RawZero
            RawFull = .RawFull
            EngZero = .EngZero
            EngFull = .EngFull
            ID = .ID
            FileType = .FileType
            Version = .Version
            StartEvNo = FormatCurrencyAsInt64(.StartEvNo)
            LogName = .LogName
            Mode = .Mode
            Area = .Area
            Priv = .Priv
            HistoryType = .HistoryType
            SamplePeriod = .SamplePeriod / 1000
            SamplePeriodRaw = .SamplePeriod
            
            sEngUnits = .sEngUnits
            Format = .Format
            
            StartTime.Raw = .StartTime
            EndTime.Raw = .EndTime
            
            DataLength = .DataLength
            FilePointer = .FilePointer
            EndEvNo = FormatCurrencyAsInt64(.EndEvNo)
        End With
               
        HeaderSize = Len(DataHdr8v6)

    Case Else
        MsgBox "This is not a valid trend file. It may be a log file or an unsupported format." & vbCrLf _
               & "Version = " & CStr(FileVersion), vbOKOnly + vbCritical
    End Select

End Function



Private Sub Class_Terminate()
    Set StartTime = Nothing
    Set EndTime = Nothing
End Sub

