VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsDataFile"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private m_DataHeader As clsDataHeader
Private Data8() As Double
Private Data2() As Integer
Private Event2() As udtEventSample2
Private Event8() As udtEventSample8


Public Property Get header() As clsDataHeader
    Set header = m_DataHeader
End Property


Public Property Get SampleSize() As Long
    Select Case m_DataHeader.Version
    Case EightByteV531, EightByteV600
        
        If m_DataHeader.HistoryType = EventTrend Then
            SampleSize = Len(Event8(0))
        Else
            SampleSize = 8
        End If

    Case TwoByteOriginal, TwoBytePreV500, TwoByteV500, TwoByteV531, TwoByteV600
        
        If m_DataHeader.HistoryType = EventTrend Then
            SampleSize = Len(Event2(0))
        Else
            SampleSize = 2
        End If
    
    Case Else
        SampleSize = 0
        MsgBox "Unknown trend version (" & CStr(m_DataHeader.Version) & ")."
    End Select
    
End Property


Public Property Get SampleValue(SampleNo As Long) As Variant
    
    Select Case m_DataHeader.HistoryType
    Case PeriodicTrend
        Select Case m_DataHeader.Version
        Case EightByteV531, EightByteV600
            SampleValue = Data8(SampleNo)
        Case TwoByteOriginal, TwoBytePreV500, TwoByteV500, TwoByteV531, TwoByteV600
            SampleValue = Data2(SampleNo)
        End Select
    Case EventTrend
        Select Case m_DataHeader.Version
        Case EightByteV531, EightByteV600
            SampleValue = Event8(SampleNo).Value
        Case TwoByteOriginal, TwoBytePreV500, TwoByteV500, TwoByteV531, TwoByteV600
            SampleValue = Event2(SampleNo).Value
        End Select
    End Select

End Property

Public Property Get SampleTime(SampleNo As Long) As Currency
    
    Select Case m_DataHeader.HistoryType
    Case PeriodicTrend
        SampleTime = 0
    Case EventTrend
        Select Case m_DataHeader.Version
        Case EightByteV531, EightByteV600
            SampleTime = Event8(SampleNo).Timestamp
        Case TwoByteOriginal, TwoBytePreV500, TwoByteV500, TwoByteV531, TwoByteV600
            SampleTime = CInt64Time(Event2(SampleNo).Timestamp, Event2(SampleNo).MS)
        End Select
    End Select

End Property


Public Function Load(FileNo As Long)

    Set m_DataHeader = New clsDataHeader
    
    m_DataHeader.Load FileNo
    
End Function


Public Function GetSamples(FileNo As Long, StartSampleNo As Long, Optional EndSampleNo As Long = 0) As Variant
    
    Dim Index As Long
    Dim SampleNo As Long
    Dim StartByte As Long
    
    StartByte = m_DataHeader.HeaderSize + 1 + ((StartSampleNo - 1) * SampleSize)
    
    Select Case SampleSize
    Case 8 '8-byte periodic
        ReDim Data8(StartSampleNo To EndSampleNo)
        Get FileNo, StartByte, Data8()
        GetSamples = Data8
    Case 16 '8-byte event
        ReDim Event8(StartSampleNo To EndSampleNo)
        Get FileNo, StartByte, Event8()
    Case 2 '2-byte periodic
        ReDim Data2(StartSampleNo To EndSampleNo)
        Get FileNo, StartByte, Data2()
        GetSamples = Data2
    Case 12 '2-byte event
        ReDim Event2(StartSampleNo To EndSampleNo)
        Get FileNo, StartByte, Event2()
    Case Else
        MsgBox "Invalid trend type:" & m_DataHeader.HistoryType
    End Select

End Function


Private Sub Class_Terminate()
    Set m_DataHeader = Nothing
End Sub
