Attribute VB_Name = "CommonDialog"
Option Explicit
 
Private Declare Function GetOpenFileName Lib "comdlg32.dll" Alias "GetOpenFileNameA" (pOpenfilename As OPENFILENAME) As Long
  
Public Enum OfnFlags
    OFN_ALLOWMULTISELECT = &H200        'Allow multiple files to be selected
    OFN_CREATEPROMPT = &H2000           'Prompt to create files that don't exist
    OFN_DONTADDTORECENT = &H2000000     'Don't add file to Windows' Recent Files list
    OFN_ENABLESIZING = &H800000         'Allow user to resize dialog
    OFN_EXPLORER = &H80000              'User explorer style (only takes effect if OFN_ALLOWMULTISELECT is used
    OFN_FILEMUSTEXIST = &H1000          'User can only enter existing filenames. Must also set OFN_PATHMUSTEXIST
    OFN_FORCESHOWHIDDEN = &H10000000    'Show hidden or system files regardless of Explorer settings (won't show hidden system files)
    OFN_HIDEREADONLY = &H4              'Hide the readonly checkbox
    OFN_LONGNAMES = &H200000            'If using non-explorer style dialog, set this to use long filenames
    OFN_NOCHANGEDIR = &H8               'Don't change default directory when dialog closes
    OFN_NODEREFERENCELINKS = &H100000   'Don't replace .lnk filenames with the path & filename they point to
    OFN_NOLONGNAMES = &H40000           'If using non-explorer style dialog, use short filenames
    OFN_NONETWORKBUTTON = &H20000       'Disable the network button
    OFN_NOTESTFILECREATE = &H10000      'Do not create file before closing the dialog
    OFN_NOVALIDATE = &H100              'Allow invalid characters in filename
    OFN_PATHMUSTEXIST = &H800           'Don't accept paths that don't exist
    OFN_READONLY = &H1                  'Set read-only checkbox by default
    OFN_SHAREAWARE = &H4000             'Ignore sharing violations
    OFN_SHOWHELP = &H10                 'Show Help button. Owner window must handle the help request
End Enum

'Dummy declarations force capitalization of enum items
#If False Then
    Public OFN_ALLOWMULTISELECT
    Public OFN_CREATEPROMPT
    Public OFN_DONTADDTORECENT
    Public OFN_ENABLESIZING
    Public OFN_EXPLORER
    Public OFN_FILEMUSTEXIST
    Public OFN_FORCESHOWHIDDEN
    Public OFN_HIDEREADONLY
    Public OFN_LONGNAMES
    Public OFN_NOCHANGEDIR
    Public OFN_NODEREFERENCELINKS
    Public OFN_NOLONGNAMES
    Public OFN_NONETWORKBUTTON
    Public OFN_NOTESTFILECREATE
    Public OFN_NOVALIDATE
    Public OFN_PATHMUSTEXIST
    Public OFN_READONLY
    Public OFN_SHAREAWARE
    Public OFN_SHOWHELP
#End If
  
Private Type OPENFILENAME
  lStructSize As Long
  hwndOwner As Long
  hInstance As Long
  lpstrFilter As String
  lpstrCustomFilter As String
  nMaxCustFilter As Long
  nFilterIndex As Long
  lpstrFile As String
  nMaxFile As Long
  lpstrFileTitle As String
  nMaxFileTitle As Long
  lpstrInitialDir As String
  lpstrTitle As String
  Flags As Long
  nFileOffset As Integer
  nFileExtension As Integer
  lpstrDefExt As String
  lCustData As Long
  lpfnHook As Long
  lpTemplateName As String
End Type
 
' Function: FileOpenDialog
'
' Arguments: Title      Text to display in titlebar (default="Open")
'            Folder     Folder to display (default is the current folder)
'            Filter     File extension filter made of pairs of descriptions and filespecs separated by pipes.
'                         Multiple filespecs may be separated by semicolons. For example:
'                         "All Files (*.*)|*.*|Graphic Files|*.jpg;*.png|"
'                         (default="All Files|*.*|")
'            Flags      Flags from OfnFlags (default=0)
'            ReadOnly   Set to TRUE by FileOpenDialog if read-only was selected by the user
'
' Return Value: Path & filename selected or VbNullString if user cancelled or there was an error
'
' Examples: strFile = FileOpenDialog()    'Default open dialog
'           strFile = FileOpenDialog("Open Graphic File", "c:\", "Graphic Files|*.jpg;*.gif|All Files|*.*|", _
'                                    OFN_HIDEREADONLY + OFN_ENABLESIZING + OFN_FILEMUSTEXIST)
'
' Notes: Sometimes VB gives a compiler error saying you need a constant if you pass a OFN flag to the function.
'        Creating the exe file seems to fix this for running the uncompiled code also
'
Function FileOpenDialog(Optional ByVal Title As String, _
                        Optional ByVal Folder As String, _
                        Optional ByVal Filter As String = "All Files|*.*|", _
                        Optional ByVal Flags As OfnFlags, _
                        Optional ByRef ReadOnly As Boolean)
  
    Dim OpenFile As OPENFILENAME
    Dim lReturn As Long
    Dim FileName As String
    
'    FileName = ExtractFileName(Folder)
    
    If Right$(Filter, 1) <> "|" Then    'Add 2 terminating pipes if there are none
        Filter = Filter & "||"
    End If
    
    If Right$(Filter, 2) <> "|" Then    'Add 1 terminating pipe if there is only 1
        Filter = Filter & "|"
    End If
 
    Filter = Replace(Filter, "|", vbNullChar)
 
    With OpenFile
        .lStructSize = Len(OpenFile)
        .lpstrFilter = Filter
        .nFilterIndex = 0
        .lpstrFile = Folder & String$(257 - Len(Folder), 0)
        .nMaxFile = Len(.lpstrFile) - 1
        .lpstrFileTitle = .lpstrFile
        .nMaxFileTitle = .nMaxFile
        .lpstrInitialDir = Folder
        .lpstrTitle = Title
        .Flags = Flags
   
        lReturn = GetOpenFileName(OpenFile)
        
        If lReturn = 0 Then
           FileOpenDialog = vbNullString
        Else
           FileOpenDialog = Trim(.lpstrFile)
        End If
        
        ReadOnly = ((.Flags And OFN_READONLY) = OFN_READONLY)
    End With
End Function
 

'Return the file name from a path & filename
Private Function ExtractFileName(PathName As String) As String
    Dim Position As Long
    
    Position = InStrRev(PathName, "\", Compare:=vbTextCompare)
    
    ExtractFileName = Right$(PathName, Len(PathName) - Position)
End Function
